/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.shader;

import committee.nova.mods.avaritia.api.client.shader.BinaryType;
import committee.nova.mods.avaritia.api.client.shader.ConstantCache;
import committee.nova.mods.avaritia.api.client.shader.NamedShaderObject;
import committee.nova.mods.avaritia.api.client.shader.ShaderConstantCache;
import committee.nova.mods.avaritia.api.client.shader.ShaderObject;
import committee.nova.mods.avaritia.api.client.shader.UniformPair;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL46;

public class BinaryShaderObject
extends NamedShaderObject
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation asset;
    private final BinaryType binaryType;
    private final String entryPoint;
    private final ShaderConstantCache constantCache = new ShaderConstantCache();
    private final Consumer<ConstantCache> specializationCallback;
    private boolean dirty = false;
    private int shaderId = -1;

    public BinaryShaderObject(String name, ResourceLocation asset, ShaderObject.ShaderType type, BinaryType binaryType, String entryPoint, Collection<UniformPair> uniforms, Consumer<ConstantCache> specializationCallback) {
        super(name, type, uniforms);
        this.asset = asset;
        this.binaryType = binaryType;
        this.entryPoint = entryPoint;
        this.specializationCallback = specializationCallback;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void alloc() {
        if (this.dirty || this.shaderId == -1) {
            if (this.shaderId == -1) {
                this.shaderId = GL20.glCreateShader((int)this.getShaderType().getGLCode());
                if (this.shaderId == 0) {
                    throw new IllegalStateException("Allocation of ShaderObject failed.");
                }
            }
            byte[] source = this.getRawSource();
            ByteBuffer sourceBuffer = BufferUtils.createByteBuffer((int)source.length).order(ByteOrder.nativeOrder());
            sourceBuffer.put(source);
            sourceBuffer.flip();
            GL46.glShaderBinary((int[])new int[]{this.shaderId}, (int)this.binaryType.getGLCode(), (ByteBuffer)sourceBuffer);
            this.specializationCallback.accept(this.constantCache);
            GL46.glSpecializeShader((int)this.shaderId, (CharSequence)this.entryPoint, (int[])this.constantCache.getIndices(), (int[])this.constantCache.getValues());
            if (GL20.glGetShaderi((int)this.shaderId, (int)35713) == 0) {
                throw new RuntimeException("ShaderProgram linkage failure. \n" + GL20.glGetShaderInfoLog((int)this.shaderId));
            }
            this.dirty = false;
        }
    }

    @Override
    public int getShaderID() {
        return this.shaderId;
    }

    @Override
    public void onLink(int programId) {
    }

    public void m_6213_(ResourceManager resourceManager) {
        this.dirty = true;
    }

    private byte[] getRawSource() {
        byte[] byArray;
        block9: {
            Resource resource = Minecraft.m_91087_().m_91098_().m_215593_(this.asset);
            InputStream istream = resource.m_215507_();
            try {
                int read;
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((read = istream.read(buffer)) != -1) {
                    ostream.write(buffer, 0, read);
                }
                byArray = ostream.toByteArray();
                if (istream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (istream != null) {
                        try {
                            istream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to read shader asset.", t);
                    return new byte[0];
                }
            }
            istream.close();
        }
        return byArray;
    }
}

